# OOD Detection Online Experiment (edited on May, 2023)

  **web_connect** is a web-based experiment that collects label information of OOD samples from human subjects. 
  The implementation is powered by [jspsych](https://www.jspsych.org/7.3/) and [flask](https://flask.palletsprojects.com/en/2.3.x/).
  Also, our code has taken a lot of references from [nivturk](https://github.com/nivlab/nivturk):
   
Contents
------------
    .
    ├── app                      
    │   ├── static              
    │   │   ├── img_clf        # Contain image files (tutorial, practice, main)
    │   │   ├── js_clf         # Contain javascript files for the experiment
    │   │   └── lib_clf        # Contain libs (jquery, jspsych)    
    │   ├── templates           # Html files
    │   ├── __init__.py         # Set the initial session information for each connection (subject)
    │   ├── app.ini             # Configuration files for run
    │   ├── experiment.py       # Allocate the image set to each subject
    │   ├── complete.py         # Contains complete logic (redirect to specific complete URL)
    │   └── ...
    ├── data                    # Saves result in JSON file for each subject
    ├── incomplete              # Saves intermediate result JSON file (if necessary)
    ├── metadata                # Saves the meta information for each subject 
    ├── reject                  # Saves the meta information for the rejected subject
    └── labeled.json            # Saves the allocated subject info for each image set (0-9) 
    
    
    

Development
------------

To run the web server for development, run through the flask::

    export FLASK_APP=app.py
    export FLASK_ENV=development
    export FLASK_RUN_PORT=9000
    $ flask run --host=0.0.0.0


To access the server, you need workerId. 

From any browser::

    http://0.0.0.0:{FLASK_RUN_PORT}/?workerId=test
   

Deploy
------------

To deploy the web server, we recommend you serve it by Gunicorn.
Gunicorn requires **Python 3.x >= 3.5**.

Install from PyPI::

    $ pip install gunicorn
    

Run through gunicorn::

    $ gunicorn -b 0.0.0.0:9000 -w 8 --threads 4 --timeout 300 --graceful-timeout 300 app:app

Replace with your own parameters for the numbers 9000 (port number), 8 (workers), 4 (threads), and 300 (timeout).


